unit MainForm;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  KZIntDet, StdCtrls, ExtCtrls, ComCtrls, Winsock, Grids, IniFiles, Psock,
  NMHttp, AppEvnts, NtfyIcon;

type
    TConnection = (isDialup, isNetwork);

type
  TfrmMannATB = class(TForm)
    KZInternetDetect1: TKZInternetDetect;
    PageControl1: TPageControl;
    TabSheet1: TTabSheet;
    TabSheet2: TTabSheet;
    TabSheet3: TTabSheet;
    lstHosts: TListBox;
    cmdAdd: TButton;
    cmdEdit: TButton;
    cmdDelete: TButton;
    Panel1: TPanel;
    Label1: TLabel;
    txtCurrentIP: TEdit;
    lstStatusHosts: TListBox;
    txtLastUpdate: TEdit;
    txtPointsTo: TEdit;
    cmdUpdate: TButton;
    Label2: TLabel;
    Label3: TLabel;
    IPTimer: TTimer;
    lstDebug: TListBox;
    HTTP: TNMHTTP;
    imgStatus: TImage;
    imgGreen: TImage;
    imgYellow: TImage;
    imgRed: TImage;
    StatusTimer: TTimer;
    SysTray: TNotificationIcon;
    ApplicationEvents1: TApplicationEvents;
    procedure FormCreate(Sender: TObject);
    procedure FormDestroy(Sender: TObject);
    procedure IPTimerTimer(Sender: TObject);
    procedure cmdAddClick(Sender: TObject);
    procedure lstStatusHostsClick(Sender: TObject);
    procedure cmdEditClick(Sender: TObject);
    procedure cmdDeleteClick(Sender: TObject);
    procedure HTTPAuthenticationNeeded(Sender: TObject);
    procedure HTTPConnectionFailed(Sender: TObject);
    procedure HTTPFailure(Cmd: CmdType);
    procedure HTTPInvalidHost(var Handled: Boolean);
    procedure HTTPSuccess(Cmd: CmdType);
    procedure StatusTimerTimer(Sender: TObject);
    procedure ApplicationEvents1Idle(Sender: TObject; var Done: Boolean);
    procedure SysTrayDblClick(Sender: TObject);
    procedure cmdUpdateClick(Sender: TObject);
    procedure ApplicationEvents1Activate(Sender: TObject);
  private
    { Private declarations }
  public
    procedure GetConnection;
    function GetLocalIP: String;
    procedure UpdateHost;
  end;

var
  frmMannATB: TfrmMannATB;
  INI: TIniFile;
  Connection: TConnection;
  UpdatingHost: Boolean = False;
  UpdatingHostName: String;
  DoneLoading: Boolean = False;

implementation

{$R *.DFM}

function CableIP : string;
type
    TaPInAddr = array [0..10] of PInAddr;
    PaPInAddr = ^TaPInAddr;
var
    phe  : PHostEnt;
    pptr : PaPInAddr;
    Buffer : array [0..63] of char;
    I    : Integer;
    GInitData      : TWSADATA;

begin
    WSAStartup($101, GInitData);
    Result := '';
    GetHostName(Buffer, SizeOf(Buffer));
    phe :=GetHostByName(buffer);
    if phe = nil then Exit;
    pptr := PaPInAddr(Phe^.h_addr_list);
    I := 0;
    while pptr^[I] <> nil do begin
      result:=StrPas(inet_ntoa(pptr^[I]^));
      Inc(I);
    end;
    WSACleanup;
end;

procedure TfrmMannATB.GetConnection;
var
   I: Integer;
begin
     I := Application.MessageBox('What is your connection type?'#13#13'YES = Dialup'#13'NO = Cable/DSL', 'Choose Connection Type', mb_yesno + mb_iconquestion);
     if (I = idYes) then
     begin
          Connection := isDialup;
          INI.WriteInteger('config', 'connection', 0);
     end;
     if (I = idNo) then
     begin
          Connection := isNetwork;
          INI.WriteInteger('config', 'connection', 1);
     end;
end;

function TfrmMannATB.GetLocalIP: String;
begin
     if (Connection = isDialup) then
     begin
          Result := KZInternetDetect1.IP;
          if (Result = '') then
             Result := '127.0.0.1';
          Exit;
     end;
     if (Connection = isNetwork) then
     begin
          Result := CableIP;
          Exit;
     end;
end;

procedure TfrmMannATB.UpdateHost;
var
   Password: String;
begin
     if (UpdatingHostName = '') then
        Exit;
     Password := INI.ReadString(UpdatingHostName, 'password', 'nada');
     try
        HTTP.Get('http://www.thebbs.org/cgi-bin/cgi_updateip.exe?username=' + UpdatingHostName + '&password=' + Password + '&IPAddress=' + txtCurrentIP.Text);
     except
           on E: ESockError do
           begin
                if (E.Message <> 'Host Lookup Failed') and (E.Message <> 'Null Remote Address') then
                   Raise ESockError.CreateFmt(E.Message, []);
           end;
     end;
end;

procedure TfrmMannATB.FormCreate(Sender: TObject);
var
   I: Integer;
   Sl: TStringList;
begin
     INI := TINIFile.Create(ChangeFileExt(Application.EXEName, '.INI'));
     I := INI.ReadInteger('config', 'connection', -1);
     if (I = 0) then
        Connection := isDialup;
     if (I = 1) then
        Connection := isNetwork;
     if (I <> 0) and (I <> 1) then
        GetConnection;
     IPTimer.Enabled := True;

     Sl := TStringList.Create;
     INI.ReadSections(Sl);
     for I := 0 to Sl.Count - 1 do
     begin
          if (Sl[I] <> 'config') then
          begin
               lstHosts.Items.Add(Sl[I]);
               lstStatusHosts.Items.Add(Sl[I]);
          end;
     end;
     Sl.Free;
end;

procedure TfrmMannATB.FormDestroy(Sender: TObject);
begin
     INI.Free;
end;

procedure TfrmMannATB.IPTimerTimer(Sender: TObject);
var
   I: Integer;
begin
     txtCurrentIP.Text := GetLocalIP;
     SysTray.Hint := txtCurrentIP.Text;
     if (txtCurrentIP.Text <> '127.0.0.1') then
        SysTray.Icon := imgGreen.Picture.Icon;
     if (txtCurrentIP.Text = '127.0.0.1') or (UpdatingHost) then
        Exit;

     for I := 0 to lstHosts.Items.Count - 1 do
     begin
          if (txtCurrentIP.Text <> INI.ReadString(lstHosts.Items[I], 'pointsto', 'nada')) and (txtCurrentIP.Text <> INI.ReadString(lstHosts.Items[I], 'lasttried', 'nada')) then
          begin
               lstDebug.Items.Add('Updating Host: "' + lstHosts.Items[I] + '"');
               INI.WriteString(lstHosts.Items[I], 'lasttried', txtCurrentIP.Text);
               INI.WriteString(lstHosts.Items[I], 'lastupdate', FormatDateTime('mmm d yyyy hh:nn', Now));
               UpdatingHost := True;
               UpdatingHostName := lstHosts.Items[I];
               UpdateHost;
               Exit;
          end;
     end;

end;

procedure TfrmMannATB.cmdAddClick(Sender: TObject);
var
   S, S1, S2: String;
   I: Integer;
begin
     S1 := InputBox('Enter Hostname', 'What is the hostname?', '');
     if (S1 = '') then
        Exit;
     S2 := InputBox('Enter Password', 'What is the password?', '');
     if (S2 = '') then
        Exit;
     S := 'Really add "' + S1 + '" using password "' + S2 + '" to the list?';
     I := Application.MessageBox(PChar(S), 'Please Verify', mb_yesno + mb_iconquestion);
     if (I = idYes) then
     begin
          INI.WriteString(S1, 'password', s2);
          lstHosts.Items.Add(S1);
          lstStatusHosts.Items.Add(S1);
     end;
end;

procedure TfrmMannATB.lstStatusHostsClick(Sender: TObject);
begin
     txtLastUpdate.Text := INI.ReadString(lstStatusHosts.Items[lstStatusHosts.ItemIndex], 'lastupdate', 'Never');
     txtPointsTo.Text := INI.ReadString(lstStatusHosts.Items[lstStatusHosts.ItemIndex], 'pointsto', 'Nothing');
     if (UpdatingHost) and (UpdatingHostName = lstStatusHosts.Items[lstStatusHosts.ItemIndex]) then
     begin
          imgStatus.Picture := imgYellow.Picture;
          Exit;
     end;
     if (txtPointsTo.Text = txtCurrentIP.Text) then
     begin
          imgStatus.Picture := imgGreen.Picture;
          Exit;
     end;
     imgStatus.Picture := imgRed.Picture;
end;

procedure TfrmMannATB.cmdEditClick(Sender: TObject);
var
   S, S1, S2: String;
   I: Integer;

begin
     if (lstHosts.ItemIndex = -1) then
        Exit;
     S2 := INI.ReadString(lstHosts.Items[lstHosts.ItemIndex], 'password', '');
     S1 := InputBox('Enter Password', 'What is the password?', S2);
     if (S1 = S2) then
        Exit;
     S := 'Really change password from "' + S2 + '" to "' + S1 + '"?';
     I := Application.MessageBox(PChar(S), 'Please Verify', mb_yesno + mb_iconquestion);
     if (I = idYes) then
        INI.WriteString(lstHosts.Items[lstHosts.ItemIndex], 'password', S1);
end;

procedure TfrmMannATB.cmdDeleteClick(Sender: TObject);
var
   S: String;
   I: Integer;
begin
     if (lstHosts.ItemIndex = -1) then
        Exit;
     S := 'Really delete host "' + lstHosts.Items[lstHosts.ItemIndex] + '"?';
     I := Application.MessageBox(PChar(S), 'Please Verify', mb_yesno + mb_iconquestion);
     if (I = idYes) then
     begin
          INI.EraseSection(lstHosts.Items[lstHosts.ItemIndex]);
          lstStatusHosts.Items.Delete(lstHosts.ItemIndex);
          lstHosts.Items.Delete(lstHosts.ItemIndex);
     end;
end;

procedure TfrmMannATB.HTTPAuthenticationNeeded(Sender: TObject);
begin
     lstDebug.Items.Add('   Authorization Needed');
     UpdatingHostName := '';
     UpdatingHost := False;
end;

procedure TfrmMannATB.HTTPConnectionFailed(Sender: TObject);
begin
     lstDebug.Items.Add('   Connection Failed');
     UpdatingHostName := '';
     UpdatingHost := False;
end;

procedure TfrmMannATB.HTTPFailure(Cmd: CmdType);
begin
     lstDebug.Items.Add('   Failure');
     UpdatingHostName := '';
     UpdatingHost := False;
end;

procedure TfrmMannATB.HTTPInvalidHost(var Handled: Boolean);
begin
     lstDebug.Items.Add('   Invalid Host');
     UpdatingHostName := '';
     UpdatingHost := False;
end;

procedure TfrmMannATB.HTTPSuccess(Cmd: CmdType);

function TheBBS(S: String): String;
var
   TempStr: String;
   I: Integer;
   InBracket: Boolean;
begin
     TempStr := '';
     I := 0;
     InBracket := False;
     While I < Length(S) do
     begin
          Inc(I);
          if (S[I] = '<') then
          begin
               InBracket := True;
               Continue;
          end;
          if (S[I] = '>') then
          begin
               InBracket := False;
               Continue;
          end;
          if (InBracket) then Continue;
          if (S[I] in [#33..#126]) then
             TempStr := TempStr + S[I];
     end;
     TheBBS := Copy(TempStr, 1, 4);
end;

var
   S: String;
begin
     S := TheBBS(HTTP.Body);
     if (Copy(S, 1, 4) = '1002') then
        S := 'Invalid Password';
     if (Copy(S, 1, 4) = '1014') then
        S := 'Invalid Hostname';
     if (Copy(S, 1, 4) = '1015') then
        S := 'Host points to: ' + txtCurrentIP.Text;
     lstDebug.Items.Add('   ' + S);
     if (Copy(S, 1, 4) = 'Host') then
        INI.WriteString(UpdatingHostName, 'pointsto', txtCurrentIP.Text);
     UpdatingHostName := '';
     UpdatingHost := False;
end;

procedure TfrmMannATB.StatusTimerTimer(Sender: TObject);
begin
     if (lstStatusHosts.ItemIndex = -1) then
        Exit;
     txtLastUpdate.Text := INI.ReadString(lstStatusHosts.Items[lstStatusHosts.ItemIndex], 'lastupdate', 'Never');
     txtPointsTo.Text := INI.ReadString(lstStatusHosts.Items[lstStatusHosts.ItemIndex], 'pointsto', 'Nothing');
     if (UpdatingHost) and (UpdatingHostName = lstStatusHosts.Items[lstStatusHosts.ItemIndex]) then
     begin
          imgStatus.Picture := imgYellow.Picture;
          Exit;
     end;
     if (txtPointsTo.Text = txtCurrentIP.Text) then
     begin
          imgStatus.Picture := imgGreen.Picture;
          Exit;
     end;
     imgStatus.Picture := imgRed.Picture;
end;

procedure TfrmMannATB.ApplicationEvents1Idle(Sender: TObject;
  var Done: Boolean);
begin
     ShowWindow(Application.Handle, SW_HIDE);
end;

procedure TfrmMannATB.SysTrayDblClick(Sender: TObject);
begin
     Application.Restore;
     Application.BringToFront;
end;

procedure TfrmMannATB.cmdUpdateClick(Sender: TObject);
begin
     if (lstStatusHosts.ItemIndex = -1) or (UpdatingHost) then
        Exit;
     lstDebug.Items.Add('Updating Host: "' + lstStatusHosts.Items[lstStatusHosts.ItemIndex] + '"');
     INI.WriteString(lstStatusHosts.Items[lstStatusHosts.ItemIndex], 'lasttried', txtCurrentIP.Text);
     INI.WriteString(lstStatusHosts.Items[lstStatusHosts.ItemIndex], 'lastupdate', FormatDateTime('mmm d yyyy hh:nn', Now));
     UpdatingHost := True;
     UpdatingHostName := lstStatusHosts.Items[lstStatusHosts.ItemIndex];
     UpdateHost;
end;

procedure TfrmMannATB.ApplicationEvents1Activate(Sender: TObject);
begin
     if Not(DoneLoading) then
     begin
          DoneLoading := True;
          Application.Minimize;
     end;
end;

end.
