#!/usr/bin/perl
use strict;
#################################################################
##  mpupdate - Version 1.5				       ##
##  By Michael Preslar (mpreslar@mailcity.com)		       ##
##  http://www.elysoft.org				       ##
##							       ##
##  A dynamic dns updater for Thebbs.org and DtDNS.net	       ##
##  for *nix.				 		       ##
##							       ##
##  -Works for single machines				       ##
##  -Works for machines behind their ISPs proxy		       ##
##  -Options can be set from the command line		       ##
##							       ##
## To use:						       ##
##							       ##
##  First Method.. Edit the settings below to what you need.   ##
##							       ##
##  Second Method.. Use the command line.. example..           ##
##  ./mpup2.pl -s:whichserver -u:hostname -p:password	       ##
##  You can also add a -i:ip or url			       ##
##  This can be used if you need to go offline or something.   ##
##  If you dont specify an ip, itll be gotten from	       ##
##  your machine..					       ##
##							       ##
##  whichserver would be either thebbs or dtdns		       ##
##  hostname would be your hostname with that dydns server     ##
##  password would be your password with that dydns server     ##
##							       ##
##  Make sure you chmod o+x mpup2.pl and 		       ##
##  chown root.root mpup2.pl .. Why does it have to be owned   ##
##  by root? On most systems, you have to be root to run       ##
##  ifconfig.. So, this script needs to be root..	       ##
#################################################################


my ($ifconfig,$device,$username,$password,$mode,$ip,$result,$link,$text,$i);

# the path to ifconfig .. normally, this path is already
# correct, but your system might be different.
$ifconfig = '/sbin/ifconfig';

# modify this.. could be ppp0, eth0, or something similar
$device = 'eth0';

# minimal
# $username is your hostname $password is your password
# if using dtdns this is your full hostname, eg. blah.dtdns.net
# e.g. $username = 'blah.thebbs.org';
# e.g. $username = 'blah.dtdns.org';
$username = 'blah.com';  # your username with the dydns server
$password = '';  # your password with the dydns server

# set this to the right number..
# 1 = thebbs .. 2 = dtdns 
$mode = 1;

#####################################################
## You shouldnt have to modify anything below here ##
#####################################################

# get the ip
$ip='';


# process any command line options
if ($ARGV[0]) {
 for ($i=0;$i<=$#ARGV;$i++) {
  if ($ARGV[$i] =~ /^\-s\:/i) {
   $ARGV[$i] =~ s/^\-s\://i;
   if ($ARGV[$i] eq 'thebbs') { $mode=1;}
   elsif($ARGV[$i] eq 'dtdns') { $mode=2;} 
  }
  elsif ($ARGV[$i] =~ /^\-u\:/i) {
   $ARGV[$i] =~ s/^\-u\://i;
   $username=$ARGV[$i];
  }
  elsif ($ARGV[$i] =~ /^\-p\:/i) {
   $ARGV[$i] =~ s/^\-p\://i;
   $password=$ARGV[$i];
  }
  elsif ($ARGV[$i] =~ /^\-i\:/i) {
   $ARGV[$i] =~ s/^\-i\://i;
   $ip=$ARGV[$i];
  }
 } # for
} # if

# this'll be ran if ip isnt specified on the command line
if ($ip = '') {
 $text = `"$ifconfig" "$device"`; 
  if ($text =~ /$device.*inet addr:(\d{1,3}\.\d{1,3}\.\d{1,3}\.\d{1,3})\s.*collisions/sg) {
   $ip = $1; 
  }
}

if ($ip eq '') {
 print "Ack! No IP detected!\n";
 exit;
}


# do it
if ($mode == 1) {
 $link = "http://www.thebbs.org/cgi-bin/cgi_updateip.exe?username=$username&password=$password&ipaddress=$ip";
 &normal_update
}
elsif ($mode == 2) {
 $link = "http://www.dtdns.net/autodns.cfm?id=$username&pw=$password&ip=$ip&client=mpupdate1";
 &normal_update;
 }

# heres where we actually do the updating.
sub normal_update {
my @result;
`lynx -dump "$link" > mpupresult`;

open(FILE,'mpupresult');
@result = <FILE>;
close(FILE);
`rm -f mpupresult`;

# dtdns result codes
if ($result[1] =~ /host.+now points to/i) {
 print "Success!\n";
}
elsif ($result[1] =~ /the hostname you supplied is not valid/i) {
 print "Invalid hostname\n";
}
elsif ($result[1] =~ /the password you supplied is not valid/i) {
 print "Invalid password\n";
}
# thebbs result codes
elsif ($result[2] =~ /the ip address has been updated/i) {
 print "Success\n";
}
elsif ($result[2] =~ /incorrect password/i) {
 print "Invalid password\n";
}
elsif ($result[2] =~ /unknown hostname/i) {
 print "Invalid hostname\n";
}


}

