program EDNSCLI;
(*
**
** EleDynDNS client program
**
** Copyright (c) 1999 by Maarten Bekers (info@elebbs.com)
**
** Created : 27-Dec-1999
** Last update : 27-Dec-1999
**
** Note: This is just a simple example of how to write a Dynamic DNS
**       updater client. You are free to enhance this in any way you like.
**       If you have any comments or suggested additions, please email me.
**
*)
uses SockFunc,                         { This unit is in the EleCOM package }
      SockDef,                         { This unit is in the EleCOM package }
       SysUtils,
       {$IFDEF WIN32}
         Windows;
       {$ENDIF}

       {$IFDEF OS2}
         OS2Base;
       {$ENDIF}

(*-+-*-+-*-+-*-+-*-+-*-+-*-+-*-+-*-+-*-+-*-+-*-+-*-+-*-+-*-+-*-+-*-+-*-+-*-*)

const Version    = '0.01';
      IniName    = 'ednscli.ini';
      HostName   : String = 'www.thebbs.org';

      Username   : String = '';
      Password   : String = '';
      IpAddress  : String = '127.0.0.1';
      UseIpNumber: String = '0';

      ErrorStr   : String = '';
      HttpPort   : Longint = 80;
      SockHandle : Longint = -1;


var TempBuf : Array[0..1024 * 5] of Char;    { don't use this at home, kids! }
    TempPtr : Longint;
    TempLen : Longint;
    TempLong: Longint;
    TempStr : String;

(*-+-*-+-*-+-*-+-*-+-*-+-*-+-*-+-*-+-*-+-*-+-*-+-*-+-*-+-*-+-*-+-*-+-*-+-*-*)

function IpToStr(Addr: tIn_Addr): String;
var ValStr : String;
    TempStr: String;
begin
  TempStr := '';

  Str(Addr.ClassA, ValStr);
  TempStr := TempStr + ValStr + '.';
  Str(Addr.ClassB, ValStr);
  TempStr := TempStr + ValStr + '.';
  Str(Addr.ClassC, ValStr);
  TempStr := TempStr + ValStr + '.';
  Str(Addr.ClassD, ValStr);
  TempStr := TempStr + ValStr;

  Result := TempStr;
end; { func. IpToStr }

(*-+-*-+-*-+-*-+-*-+-*-+-*-+-*-+-*-+-*-+-*-+-*-+-*-+-*-+-*-+-*-+-*-+-*-+-*-*)

function TryConnect(HostName: String): Boolean;
var ReturnCode: Longint;
    IpAddr    : tIn_Addr;
    ClientAddr: pSockAddr;
begin
  New(ClientAddr);

  FillChar(ClientAddr^, SizeOf(ClientAddr^), #00);
  ReturnCode := SockSocket(AF_INET, SOCK_STREAM, IPPROTO_TCP);

  if ReturnCode <> -1 then
    begin
      SockHandle := ReturnCode;

      IpAddr := SockInetAddr(HostName);  { Assume we get passed an IP address }
      if IpAddr.IpAddr = INADDR_NONE then
        begin
          IpAddr.IpAddr := SockGetHostAddrByName(HostName);
        end; { if }

      if ReturnCode <> -1 then
        begin
          ClientAddr^.Sin_Addr.IPAddr := IpAddr.IpAddr;
          ClientAddr^.Sin_Port        := sockhtons(HttpPort);
          ClientAddr^.Sin_Family      := AF_INET;

          ReturnCode := SockConnect(SockHandle,
                                    ClientAddr^);
          if ReturnCode = -1 then
            ErrorStr := 'Unable to connect (' + SockGetErrStr(SockErrorNo) + ')';
        end
         else ErrorStr := 'Unable to get hostname (' + SockGetErrStr(SockErrorNo) + ')';
    end
     else ErrorStr := 'Unable to intiailize socket (' + SockGetErrStr(SockErrorNo) + ')';

  SocksetBlockingIO(SockHandle, false);

  Result := (ErrorStr = '');
end; { func. TryConnect }

(*-+-*-+-*-+-*-+-*-+-*-+-*-+-*-+-*-+-*-+-*-+-*-+-*-+-*-+-*-+-*-+-*-+-*-+-*-*)

procedure DoSleep(L: Longint);
begin
  {$IFDEF WIN32}
    Sleep(l);
  {$ENDIF}

  {$IFDEF OS2}
    DosSleep(l);
  {$ENDIF}
end; { proc. DoSleep }

(*-+-*-+-*-+-*-+-*-+-*-+-*-+-*-+-*-+-*-+-*-+-*-+-*-+-*-+-*-+-*-+-*-+-*-+-*-*)

function RequestUrl(const Str: String): Longint;
var TempStr: ShortString;
    Count  : Longint;
begin
  {-- Send the request to the server ----------------------------------------}
  TempStr := Str + #13#10 + #13#10;
  SockSend(SockHandle, @TempStr[1], Length(TempStr), 0);

  {-- We assume all went OK, let''s wait for the response -------------------}
  Count := 0;
  REPEAT
    DoSleep(250);

    if SockDataAvail(SockHandle) then BREAK;
    Inc(Count);
  UNTIL (Count > 56);                         { Max. wait approx 25 seconds }
  DoSleep(1000);  { Rough estimate of avg. secs to wait before data is here }

  {-- Get all data on one large buffer, discard the rest --------------------}
  {-- Socket is set to non-blocking mode, so if the returned data is --------}
  {-- less, the socket will not wait but return anyway ----------------------}
  FillChar(TempBuf, SizeOf(TempBuf), #0);
  SockRecv(SockHandle, @TempBuf, SizeOf(TempBUF) - 1, 0);

  {-- Make sure that GetNextLine variables are initialized ------------------}
  TempPtr := 0;
  TempLen := StrLen(TempBuf);
  TempStr := '';
end; { proc. RequestUrl }

(*-+-*-+-*-+-*-+-*-+-*-+-*-+-*-+-*-+-*-+-*-+-*-+-*-+-*-+-*-+-*-+-*-+-*-+-*-*)

function GetNextLine: String;
begin
  {-- Get whole lines from this string --------------------------------------}
  While TempPtr < TempLen do
    begin
      if TempBuf[TempPtr] <> #13 then
        TempStr := TempStr + TempBuf[TempPtr]
          else begin
                 GetNextLine := TempStr;
                 TempStr := '';

                 if TempBuf[TempPtr + 1] = #10 then Inc(TempPtr, 2);

                 BREAK;
               end; { else }

      Inc(TempPtr);
    end; { while }
end; { func. GetNextline }

(*-+-*-+-*-+-*-+-*-+-*-+-*-+-*-+-*-+-*-+-*-+-*-+-*-+-*-+-*-+-*-+-*-+-*-+-*-*)

function ParseHttpReturn: Longint;
var TempHdr: String;
    Count  : Longint;
begin
  TempHdr := GetNextLine;                      { Get the HTTP response code }
  Count := 0;
  REPEAT
    Inc(Count);
  UNTIL (GetNextLine = '') OR (Count > 200);

  Val(Copy(TempHdr, Length('HTTP/1.1  '), 3), Count, Count);
  ParseHttpReturn := Count;
end; { func. ParseHttpReturn }

(*-+-*-+-*-+-*-+-*-+-*-+-*-+-*-+-*-+-*-+-*-+-*-+-*-+-*-+-*-+-*-+-*-+-*-+-*-*)

function ParseHtmlReturn: String;
var IsTitle   : String;
    Count     : Longint;
    TempTag   : String;
    EndTitle  : Boolean;
    TagContent: String;
begin
  Count := 0;
  IsTitle := '';
  TagContent := '';
  EndTitle := false;

  REPEAT
    TempStr := GetNextLine;

    While Pos('<', TempStr) > 0 do
      begin
        TempTag := Copy(TempStr, Pos('<', TempStr), Pos('>', TempStr));
        Delete(TempStr, Pos('<', TempStr), Length(TempTag));

        TagContent := TempStr;

        if TempTag = '<TITLE>' then
          begin
            EndTitle := TRUE;
          end; { if }

        if TempTag = '</TITLE>' then
          begin
            EndTitle := FALSE;

            While (TagContent[1] = #32) AND (Length(TagContent) > 1) do
              Delete(TagContent, 1, 1);
            While (TagContent[Length(TagContent)] = #32) AND (Length(TagContent) > 1) do
              Delete(TagContent, Length(Tagcontent), 1);

            IsTitle := TagContent;
          end; { if }
      end; { while }

  UNTIL (TempPtr >= TempLen) OR (IsTitle <> '') OR (Count > 200);

  ParseHtmlReturn := isTitle;
end; { proc. ParseHtmlreturn }

(*-+-*-+-*-+-*-+-*-+-*-+-*-+-*-+-*-+-*-+-*-+-*-+-*-+-*-+-*-+-*-+-*-+-*-+-*-*)

function ConvertCgiCode(TempStr: String): String;
var Code: Longint;
begin
  Val(TempStr, TempLong, Code);
  ConvertCgiCode := 'Unknown return code, check for client updates (' + TempStr + ')';

  Case TempLong of
     1000 : Result := 'Username already exists';
     1001 : Result := 'Passwords do not match';
     1002 : Result := 'Incorrect password entered';
     1003 : Result := 'Username field is missing from URL';
     1004 : Result := 'Password field is missing from URL';
     1005 : Result := 'Password2 field is missing from URL';
     1006 : Result := 'Description field is missing from URL';
     1007 : Result := 'Email field is missing from URL';
     1008 : Result := 'Successfully added to the userbase';
     1009 : Result := 'Invalid email address entered';
     1010 : Result := 'DNS add failure (system error)';
     1011 : Result := 'Duplicate email address';
     1012 : Result := 'Domainname of email address is invalid (blacklisted?)';
     1013 : Result := 'IP address to update to is missing';
     1014 : Result := 'Unknown username';
     1015 : Result := 'Updated successfully';
     1016 : Result := 'Realname is missing';
     1017 : Result := 'Record updated successfully';
     1018 : Result := 'Account has been activated';
     1019 : Result := 'Your password has been mailed';
     1020 : Result := 'Username is invalid (reserved?)';
     1021 : Result := '(dohh)'; { code internally used to display editdns.html }
  end; { case }

end; { func. ConvertCgiCode }

(*-+-*-+-*-+-*-+-*-+-*-+-*-+-*-+-*-+-*-+-*-+-*-+-*-+-*-+-*-+-*-+-*-+-*-+-*-*)

procedure LoadConfig;
var TempStr: String;
    Temp_F : Text;
    Command: String;
begin
  Assign(Temp_F, IniName);
  {$i-} Reset(Temp_F); {$i+}
  if IoResult = 0 then
    begin
      While NOT Eof(Temp_F) do
        begin
          {$i-} ReadLn(Temp_F, TempStr); {$i+}
          if IoResult > 0 then BREAK;

          Command := Copy(TempStr, 1, Pos(':', TempStr) - 1);
          Delete(TempStr, 1, Length(Command) + 2);

          if Command = 'username' then Username := TempStr;
          if Command = 'password' then Password := TempStr;
          if Command = 'useip#' then UseIpNumber := TempStr;
        end; { while }


      {$i-} Close(Temp_F); {$i+}
      if IoResult > 0 then ;
    end; { if }
end; { proc. LoadConfig }

(*-+-*-+-*-+-*-+-*-+-*-+-*-+-*-+-*-+-*-+-*-+-*-+-*-+-*-+-*-+-*-+-*-+-*-+-*-*)

function GetHostAddr: tIn_Addr;
type tAddrList = Array[0..250] of pIn_Addr;
     pAddrList = ^tAddrList;

var Hosts   : pHostEnt;
    AddrList: pAddrList;
    IpNr    : Longint;
    Code    : Longint;
    TempAddr: tIn_Addr;
begin
  FillChar(TempAddr, SizeOf(TempAddr), 0);
  Val(UseIpNumber, IpNr, Code);
  if (IpNr > High(tAddrList)) then IpNr := High(tAddrList);

  Hosts := SockGetHostByName(SockGetHostName);
  AddrList := pAddrList(Hosts^.h_Addr_List);

  if AddrList <> nil then
    begin
      if AddrList^[IpNr] <> nil then
        GetHostAddr := AddrList^[IpNr]^
          else GetHostAddr := TempAddr;
    end
      else GetHostAddr := TempAddr;
end; { func. GetHostAddr }

(*-+-*-+-*-+-*-+-*-+-*-+-*-+-*-+-*-+-*-+-*-+-*-+-*-+-*-+-*-+-*-+-*-+-*-+-*-*)

begin
  WriteLn('EDNSCLI v', Version, ' - (c)1999 by Maarten Bekers');
  WriteLn;

  {-- Set hostname to the one set on the commandline ------------------------}
  if ParamCount > 0 then
    Hostname := ParamStr(1);

  {-- Find out user settings ------------------------------------------------}
  LoadConfig;

  {-- Find out the current user''s ip-address -------------------------------}
  SockInit;
  IpAddress := IpToStr(GetHostAddr);

  WriteLn(#254, #32, 'Running at: ', SockGetHostName, ' (', IpAddress, ')');
  WriteLn(#254, #32, 'Username  : ', UserName);
  WriteLn(#254, #32, 'Contacting: ', HostName);
  if TryConnect(HostName) then
    begin

      WriteLn(#254, #32, 'Contacted successfully, running CGI');
      RequestUrl(Format('GET %s HTTP/1.0', [
         Format('/cgi-bin/cgi_updateip.exe?username=%s&' +
                                          'password=%s&' +
                                          'ipaddress=%s',
                  [Username, Password, IpAddress])]));

      TempLong := ParseHttpReturn;
      if TempLong = 200 then
        begin
          WriteLn(#254, #32, 'CGI run successfully, parsing return code');

          TempStr := ParseHtmlReturn;
          WriteLn(#254, #32, 'Server returned "', ConvertCgiCode(TempStr), '"');
        end
          else WriteLn(#254, #32, 'Server returned HTTP error code ', TempLong);
    end
      else WriteLn(#254, #32, 'Connection failed (', ErrorStr, ').');

  {-- All through and done --------------------------------------------------}
  Writeln(#254, #32, 'Done.');
end. { EDNSCLI }
