package jimb;

import java.util.*;
import java.net.*;
import java.io.*;

class dyndns {

    public static String getLine(InputStream is ) {
	String s = "";
	String c = "";
	try {
	    while (is.available()>0 && !c.equals("\n")) {
		s += c;
		do {
		    c = "" + (char)is.read();
		    //		    System.out.print(c);
		} while (c.equals("\r"));
	    }
	} catch (IOException e) {
	    return null;
	}
	return s;
    }

    public static String convertCgiCode(String sCode) {
	int iCode = Integer.parseInt(sCode);
	String sResult;
	switch (iCode) {
	case 1000 : sResult = "Username already exists"; break;
	case 1001 : sResult = "Passwords do not match"; break;
	case 1002 : sResult = "Incorrect password entered"; break;
	case 1003 : sResult = "Username field is missing from URL"; break;
	case 1004 : sResult = "Password field is missing from URL"; break;
	case 1005 : sResult = "Password2 field is missing from URL"; break;
	case 1006 : sResult = "Description field is missing from URL"; break;
	case 1007 : sResult = "Email field is missing from URL"; break;
	case 1008 : sResult = "Successfully added to the userbase"; break;
	case 1009 : sResult = "Invalid email address entered"; break;
	case 1010 : sResult = "DNS add failure (system error)"; break;
	case 1011 : sResult = "Duplicate email address"; break;
	case 1012 : sResult = "Domainname of email address is invalid (blacklisted?)"; break;
	case 1013 : sResult = "IP address to update to is missing"; break;
	case 1014 : sResult = "Unknown username"; break;
	case 1015 : sResult = "Updated successfully"; break;
	case 1016 : sResult = "Realname is missing"; break;
	case 1017 : sResult = "Record updated successfully"; break;
	case 1018 : sResult = "Account has been activated"; break;
	case 1019 : sResult = "Your password has been mailed"; break;
	case 1020 : sResult = "Username is invalid (reserved?)"; break;
	case 1021 : sResult = "(dohh)"; break;
	default:
	    sResult = "Unknown cgi return code";
	}
	return sResult;
    }

    public static void main(String[] args) {
	try {
	    if (args.length<2 || args.length>4) {
		System.err.println("Error: Invalid number of parameters");
		System.err.println("Usage: dyndns accountname password [hostname] [yourip]");
		return;
	    }

	    String sUserName = args[0];
	    String sPassword = args[1];
	    String sHostName = "www.thebbs.org";
	    if (args.length>=3) {
		sHostName = args[2];
	    }

	    System.out.println("Username  : " + sUserName);
	    System.out.println("Password  : " + sPassword);

	    System.out.println("Contacting: " + sHostName);
	    InetAddress ipServer = InetAddress.getByName(sHostName);
	    System.out.println("Contacting: " + ipServer.getHostAddress());

	    String sIpLocalHost;
	    if (args.length==4) {
		sIpLocalHost = args[3];
	    } else {
		InetAddress ipLocalHost;
		ipLocalHost = (new Socket(ipServer, 80)).getLocalAddress();
		sIpLocalHost = ipLocalHost.getHostAddress();
	    }
	    System.out.println("Running at: " + sIpLocalHost);
		
	    URL url = new URL("http://" + ipServer.getHostAddress() +  
			      "/cgi-bin/cgi_updateip.exe" + 
			      "?username=" + sUserName + 
			      "&password=" + sPassword +
			      "&ipaddress=" + sIpLocalHost);
	    
	    InputStream is = url.openStream();
	    // Wait for data to arrive...
	    Thread.sleep(1000);
	    String sLine;
	    while ((sLine=getLine(is))!=null && (sLine.indexOf("<TITLE>")==-1))
	    {
		// Eat lines until the title shows up
		//		System.out.println("Ate: " + sLine);
	    }
	    String sReturn = getLine(is).trim();
	    is.close();

	    System.out.println("Returned  : " + sReturn);
	    System.out.println("Returned  : " + convertCgiCode(sReturn));

	} catch (Exception e) {
	    System.err.println("Unhandled Exception :");
	    e.printStackTrace(System.err);
	}
    }
}

